/*****************************************************************************
  Generate random sample from gamma(a,beta), 
  for 0<a<=1 GS, Ahrens and Dieter 1974  
  for a>1 and a<=2.5 GKM1, Cheng and Feast 1979
  for a>1 and a>2.5  GKM2, Cheng and Feast 1979
  Density function: f(a,beta)=(beta^a)*(z^{a-1})*(e^{-z*beta})/gamma(a)
******************************************************************************/

float  rGamma(a,beta)
float  a;
float  beta;
{ 
  float  y,u1,u2,b,e;
  float  c1,c2,c3,c4,c5,z;
  long   lnum;

  e=exp(1.0);
  b=(a+e)/e;
  c1=a-1.0;
  c2=(a-1.0/(6.0*a))/c1;
  c3=2.0/c1;
  c4=c3+2.0;
  c5=sqrt(a);

  if ( a <= 1.0 ){
       do {   
            lnum=rand(); u1=ran3(&lnum);
            lnum=rand(); u2=ran3(&lnum);
            y=b*u1;
            if ( y <= 1.0 ) { 
                 z=pow(y,1.0/a);
                 if ( u2 <= exp(-z) ) break;
                 }       
            else { 
                   z=-log((b-y)/a);
                   if ( z <= pow(u2,1.0/(a-1.0))) break;
                   }
           }while(1);
        return(z/beta);
       }
  else {
        if (  a<= 2.5 ) { 
      do{
        lnum=rand();
        u1=ran3(&lnum);
        lnum=rand();
        u2=ran3(&lnum);
        z=c2*u2/u1;
        if(c3*u1-c4+z+1.0/z<=0) break;
        if(c3*log(u1)-log(z)+z-1.0<=0) break;
      }while(1);
      return(c1*z/beta);
    }
    else{
      do{
        do{
          lnum=rand();
          u1=ran3(&lnum);
          lnum=rand();
          u2=ran3(&lnum);
          y=u2+(1.0-1.857764*u1)/c5;
        }while(y<=0.0||y>=1.0);
        z=c2*u2/y;
        if(c3*y-c4+z+1.0/z<=0) break;
        if(c3*log(y)-log(z)+z-1.0<=0) break;
      }while(1);
      return(c1*z/beta);
    }
  }

}/* end */       

